let $$ = require('cdev/debug')({debug: 'cache', path: module.id, prefix: '[isg.xpert.archive]'});
$$.pdf = require('/agorum/roi/customers/cdev.ncore/js/utils/pdf')($$);
$$.objects = require('common/objects');

// const metadataCollectionBuilder = require('../../Standard/js/metadata-collection-builder');

let loadSuccess = (object, pdDocument) => {
  $$.debug('success', object.name, pdDocument.getNumberOfPages());
};
let loadError = (object, e) => {
  $$.debug('error', object, e);
};
let loadValidate = (object, pdDocument) => {
  let pages = pdDocument.getNumberOfPages();
  $$.debug('pages:', pages);
};

// let level0 = 'isg_xpert_archive_insNumber';
let level1 = 'isg_xpert_archive_processLvl2';
let level2 = 'isg_xpert_archive_orderNumber';
let level3 = 'isg_xpert_archive_processLvl3';
let level4 = 'name';

// let insNumber = 'MD_6780792';
let insNumber = 'N263288018';

// let query = 'inpath:8530925 nameextension:pdf';
let query =
  'area:(mdb archive records) classname:FILEOBJECT nameextension:pdf  isg_xpert_archive_insnumber:{0} NOT isg_xpert_archive_pdfvalidation:false'.format(
    insNumber
  );
let sort = [level1, level2, level3, level4];

let opts = {
  sort: sort,
  query: query,
  success: loadSuccess,
  validate: loadValidate,
  error: loadError,
};

let fileList = [];
let result = objects
  .query(query)
  .sort(level1.toLocaleLowerCase(), level2.toLocaleLowerCase(), level3.toLocaleLowerCase(), level4.toLocaleLowerCase())
  .search(
    level1.toLocaleLowerCase(),
    level2.toLocaleLowerCase(),
    level3.toLocaleLowerCase(),
    level4.toLocaleLowerCase()
  );

fileList = result.rows
  .map(row => {
    let line = [
      row[level1.toLocaleLowerCase()],
      row[level2.toLocaleLowerCase()],
      row[level3.toLocaleLowerCase()],
      row[level4.toLocaleLowerCase()],
    ].join(';');
    return line;
  })
  .join('\n');

$$.debug(result);
$$.debug(fileList);

let tree = {};
fileList.split('\n').forEach(line => {
  let fields = line.split(';');
  let current = tree;

  // Iterate through all fields except the last one, to build the hierarchy
  for (let i = 0; i < fields.length - 1; i++) {
    let field = fields[i];
    if (!current[field]) {
      current[field] = {};
    }
    current = current[field];
  }

  // The last field is the file, add it to the current hierarchy level
  let file = fields[fields.length - 1];
  if (!current.files) {
    current.files = [];
  }
  current.files.push(file);
});

function removeFilesArray(obj) {
  for (let key in obj) {
    if (obj[key].files && Object.keys(obj[key]).length === 1) {
      obj[key] = obj[key].files;
    } else if (typeof obj[key] === 'object') {
      removeFilesArray(obj[key]);
    }
  }
}

removeFilesArray(tree);

$$.debug(tree);
let print = $$.debug;

function setDestination(node, file) {
  print('Setting destination for node: ' + JSON.stringify(node) + ', file: ' + file);
}

function addChild(node, child) {
  print('Adding child to node: ' + JSON.stringify(node) + ', child: ' + JSON.stringify(child));
}

function findFirstLeaf(node) {
  if (Object.prototype.toString.call(node) === '[object Array]') {
    return node.length > 0 ? node[0] : null;
  } else {
    for (let key in node) {
      if (node.hasOwnProperty(key)) {
        let leaf = findFirstLeaf(node[key]);
        if (leaf) {
          return leaf;
        }
      }
    }
  }
  return null;
}

function processTree(tree) {
  function traverse(node, path) {
    let firstLeaf = findFirstLeaf(node);
    if (firstLeaf) {
      setDestination(path, firstLeaf);
    }

    if (Object.prototype.toString.call(node) === '[object Array]') {
      for (let i = 0; i < node.length; i++) {
        let file = node[i];
        setDestination(path, file);
        addChild(path, file);
      }
    } else {
      for (let key in node) {
        if (node.hasOwnProperty(key)) {
          let childNode = node[key];
          let newPath = path.slice(); // copy current path
          newPath.push(key); // add current key to path
          addChild(path, key);
          traverse(childNode, newPath);
        }
      }
    }
  }

  traverse(tree, []);
}

processTree(tree);

// let doc = loadFromObject(7931908, opts);
// doc && doc.close();

let merged = $$.objects.tryCreate('file', {
  name: 'merged.pdf',
  target: $$.objects.find('/agorum/roi/Files/Medizinischer Dienst Bremen/Export'), // Export
});

$$.pdf.mergeDocumentsFromQuery(merged, opts);
